/*
** Contrast, saturation, brightness
** Code of this function is adapted from TGM's shader pack
** http://irrlicht.sourceforge.net/phpBB2/viewtopic.php?t=21057
*/
/*
[configuration]
[OptionBool]
GUIName = Shadeboost
OptionName = F_BASIC_CORRECTION
DefaultValue = true

[OptionRangeInteger]
GUIName = Brightness
OptionName = bright
MinValue = 0
MaxValue = 200
StepAmount = 1
DefaultValue = 50
DependentOption = F_BASIC_CORRECTION

[OptionRangeInteger]
GUIName = Saturation
OptionName = saturation
MinValue = 0
MaxValue = 200
StepAmount = 1
DefaultValue = 50
DependentOption = F_BASIC_CORRECTION

[OptionRangeInteger]
GUIName = Contrast
OptionName = contrast
MinValue = 0
MaxValue = 200
StepAmount = 1
DefaultValue = 50
DependentOption = F_BASIC_CORRECTION
[/configuration]
*/
// For all settings: 1.0 = 100% 0.5=50% 1.5 = 150%
float4 ContrastSaturationBrightness(float4 color)
{
float sat = GetOption(saturation) / 50.0;
float brt = GetOption(bright) / 50.0;
float con = GetOption(contrast) / 50.0;
// Increase or decrease these values to adjust r, g and b color channels separately
 float AvgLumR = 0.5;
 float AvgLumG = 0.5;
 float AvgLumB = 0.5;
 float3 LumCoeff = float3(0.2125, 0.7154, 0.0721);
float3 AvgLumin = float3(AvgLumR, AvgLumG, AvgLumB);
float3 brtColor = color.rgb * brt;
float3 intensity = dot(brtColor, LumCoeff).xxx;
float3 satColor = lerp(intensity, brtColor, sat);
float3 conColor = lerp(AvgLumin, satColor, con);
color.rgb = conColor;
return color;
}
void main()
{
float4 c = Sample();
float4 color = ContrastSaturationBrightness(c);
SetOutput(color);
}